#include <iostream>
#include <fstream>
#include <vector>
#include <map>

using namespace std;

struct Film {               /// csinálunk egy Film típust, hogy könnyebben
    string cim, kategoria;  /// kezelhetővé váljanak az adatok.
    int jatekido, ev;
    string szinesz;
    float imdb;
};

class Filmek {
    map<string,vector<Film> > osszesFilm;   /// A feladatok elolvasása, és tanulmányozása után
    vector<Film> osszesFilmV;               /// eldöntjük hogy milyen adatszerkezetek kellenek.

public:
    Filmek() {                          /// A konstruktorban egyből be is olvasunk
        ifstream f("filmek.csv");       /// a szükséges adatszerekezetekbe.
        if (!f.good()) {
            cout << "hiba a fileban" << endl;
        }
        string temp;
        getline(f,temp);    /// Eldobtuk az elso felesleges sort.
        Film jelenlegi;     /// Majd csinálunk egy ideiglenes Film változót amibe beolvasunk.
        string kategoria;   /// Majd egy stringet is, ahova a map kulcsát fogjuk beolvasni.
        char kuka;          /// Majd egy kukát, ahova a ','-ket fogjuk dobni.
        /// Elkezdünk olvasni:
        while (getline(f,jelenlegi.cim,',')) {  /// Beolvasunk a címbe.

            getline(f,kategoria,',');
            jelenlegi.kategoria = kategoria;    /// Majd a két kategóriába

            /// Itt kezd izgalmas lenni. Beolvasunk a játékidőbe, majd eldobunk egy vesszőt
            /// aztán az évbe és megint eldobunk egy vesszőt.
            f >> jelenlegi.jatekido >> kuka >> jelenlegi.ev >> kuka;

            getline(f,jelenlegi.szinesz,',');   /// Beolvasunk a szinesz-be,
            f >> jelenlegi.imdb;                /// majd az imdb-be.

            /// Itt a sor végén vagyunk, beolvastunk egy float változót,
            /// de a sor vége jelet még be kell olvasni, amit nem a kukával
            /// teszünk, mert az az első karakterig olvasna, hanem így:
            f.get();

            /// Hozzáadjuk az elemünket a vectorhoz:
            osszesFilmV.push_back(jelenlegi);

            /// Majd a maphez:
            if (osszesFilm.count(kategoria)) {
                osszesFilm[kategoria].push_back(jelenlegi);
            } else {
                vector<Film> v = {jelenlegi};
                osszesFilm[kategoria] = v;
            }
        }
        f.close()   /// Lezárjuk a file-t.
    }

    void elsoFeladat() {
        /// Az elso feladat megoldásához a legegyszerűbb, ha egy vektorba beolvassuk
        /// az elején az elemeket, majd egy maxkeresést csinalunk a vektoron.
        /// Meg is csinálunk egy egyszerű maxkeresést:
        int leghosszabb = osszesFilmV[0].jatekido;
        string nev = osszesFilmV[0].cim;
        for (size_t i=1;i<osszesFilmV.size();i++) {
            if (osszesFilmV[i].jatekido > leghosszabb) {
                leghosszabb = osszesFilmV[i].jatekido;
                nev = osszesFilmV[i].cim;
            }
        }
        /// Majd kiírjuk:
        cout << "A leghosszabb jatekideju film: " << nev << " : "
             << leghosszabb << " perc jatekidovel." << endl;
    }

    void masodikFeladat() {
        /// Ehez a feladathoz a legjobb, hogyha egy olyan mapbe olvassuk be a filmeket,
        /// amelyiknek a film kategoria a kulcsa, es maga a film az ertek.

        /// Mivel már egy mapben vannak az elemek, így csak végig kell iterálnunk a mapen:
        for (auto it : osszesFilm) {
            cout << it.first << endl;       /// Kiírjuk a kategóriát.
            vector<Film> v = it.second;     /// A kulcs értékét átadjuk egy vectornak.
            for (size_t i=0;i<v.size();i++) {   /// Majd kiiratjuk a vector elemeit.
                cout << v[i].cim << "," << v[i].imdb << endl;
            }
            cout << endl;
        }
    }

    void harmadikFeladat() {
        string input;
        cin >> input;   /// Bekérünk egy kategóriát
        if (osszesFilm.count(input)) {      /// Megnézzük hogy létezik-e.
            vector<Film> v = osszesFilm.at(input);  /// Ha igen, akkor a kategória elemeit elmentjük egy vectorba.
            Film legjobb = v[0];
            float maximum = v[0].imdb;
            for (size_t i=1;i<v.size();i++) {       /// Majd végzünk egy maxkeresést.
                if (v[i].imdb > maximum) {
                    maximum = v[i].imdb;
                    legjobb = v[i];
                }
            }
            cout << "A legjobb " << input << " kategoriaju film: " << legjobb.cim   /// Majd kiírjuk a végeredményt.
                 << " amely " << legjobb.imdb << "pontot ert el." << endl;
        } else {
            cout << "Nincs ilyen kategoria." << endl; /// Ha nem létezik akkor nem csinálunk semmit.
        }
    }
};


int main() {
    Filmek osszesFilm;  /// Létrehozunk egy változót az összes filmnek.
    bool fut = true;    /// Majd írunk egy kezdetleges user interface-t.
    int userInput;
    while (fut) {
        cin >> userInput;
        switch(userInput) {
        case 1:
            osszesFilm.elsoFeladat();
            break;
        case 2:
            osszesFilm.masodikFeladat();
            break;
        case 3:
            osszesFilm.harmadikFeladat();
            break;
        case 0:
            fut = false;
            break;
        default:
            cout << "Hibas input, probalj masikat!" << endl;
            break;
        }
    }
}
